/*
 * Decompiled with CFR 0.152.
 */
package imageUtil;

import imageUtil.Image;
import imageUtil.ImageLoader;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class Example {
    public static void main(String[] args) {
        String imgLocation;
        String string = imgLocation = args.length == 1 ? args[0] : null;
        if (imgLocation == null) {
            throw new IllegalArgumentException("One argument required: path-to-image");
        }
        try {
            Image img = null;
            if (imgLocation.startsWith("http")) {
                img = ImageLoader.fromUrl(new URL(imgLocation));
            } else {
                File f = new File(imgLocation);
                if (!f.exists() || !f.isFile()) {
                    throw new IllegalArgumentException("Invalid path to image");
                }
                img = ImageLoader.fromFile(f);
            }
            System.out.println("Image source type: " + (Object)((Object)img.getSourceType()));
            System.out.println("Image dimensions: " + img.getWidth() + "x" + img.getHeight());
            Image cropped = img.crop(200, 200, 500, 350);
            cropped.writeToJPG(new File("cropped.jpg"), 0.95f);
            cropped.dispose();
            Image resized = img.getResizedToWidth(400);
            Example.softenAndSave(resized, 0.95f, 0.0f);
            Example.softenAndSave(resized, 0.95f, 0.1f);
            Example.softenAndSave(resized, 0.95f, 0.2f);
            Example.softenAndSave(resized, 0.95f, 0.3f);
            Example.softenAndSave(resized, 0.8f, 0.08f);
            Example.softenAndSave(resized, 0.6f, 0.08f);
            Example.softenAndSave(resized, 0.4f, 0.08f);
            resized.dispose();
            resized.writeToFile(new File("resized--q0.95--s0.0--nocodec.jpg"));
            Example.squareIt(img, 400, 0.0, 0.95f, 0.08f);
            Example.squareIt(img, 400, 0.1, 0.95f, 0.08f);
            Example.squareIt(img, 400, 0.2, 0.95f, 0.08f);
            Example.squareIt(img, 50, 0.0, 0.95f, 0.08f);
            Example.squareIt(img, 50, 0.1, 0.95f, 0.08f);
            Example.squareIt(img, 50, 0.1, 0.5f, 0.08f);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private static void softenAndSave(Image img, float quality, float soften) throws IOException {
        img.soften(soften).writeToJPG(new File("resized--q" + quality + "--s" + soften + ".jpg"), quality);
    }

    private static void squareIt(Image img, int width, double cropEdges, float quality, float soften) throws IOException {
        Image square = img.getResizedToSquare(width, cropEdges).soften(soften);
        square.writeToJPG(new File("square--w" + width + "--e" + cropEdges + "--q" + quality + ".jpg"), quality);
        square.dispose();
    }
}

